package com.agilex.healthcare.adr.service;

import com.agilex.healthcare.adr.model.DemographicMapper;
import com.agilex.healthcare.adr.model.GetEESummaryRequest;
import com.agilex.healthcare.mobilehealthplatform.adr.AdrConfiguration;
import com.agilex.soap.Message;
import com.agilex.soap.Service;

public class SupplementalDemographicsService {

	public DemographicMapper getDemographics(String patientId, AdrConfiguration configuration) {
		Service service = new Service(configuration.getEndPointUrl(), configuration.getConnectionTimeout(), configuration.getReadTimeout());

		GetEESummaryRequest builder = new GetEESummaryRequest(configuration);
		Message request = builder.build(patientId);

		Message response = request.send(service);

		return new DemographicMapper(response.toString());
	}
}
